<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>FPL Maestros — Team of the Month</title>
  <style>
    body {
      margin: 0;
      background: #0a1f17;
      color: #fff;
      font-family: Arial, sans-serif;
    }
    .poster {
      max-width: 800px;
      margin: 20px auto;
      background: #062619;
      border-radius: 12px;
      overflow: hidden;
      box-shadow: 0 10px 30px rgba(0,0,0,0.7);
    }
    .top {
      display: flex;
      justify-content: space-between;
      align-items: center;
      background: #0b331d;
      padding: 12px 20px;
    }
    .top .left {
      display: flex;
      align-items: center;
    }
    .month-label {
      background: #104b30;
      padding: 6px 14px;
      border-radius: 6px;
      font-size: 14px;
      margin-right: 12px;
    }
    .title-label {
      font-size: 16px;
      color: #8ad9a2;
      font-weight: bold;
    }
    .top .right {
      font-size: 48px;
      font-weight: bold;
    }
    .pitch-area {
      position: relative;
      background: linear-gradient(180deg, #145e35 0%, #0c4729 100%);
      padding: 20px;
    }
    .pitch {
      position: relative;
      background: #117a45;
      height: 520px;
      border-radius: 8px;
      overflow: hidden;
      box-shadow: inset 0 8px 20px rgba(0,0,0,0.5);
    }
    .card {
      width: 140px;
      background: rgba(0,0,0,0.3);
      border-radius: 8px;
      text-align: center;
      padding: 6px;
      position: relative;
      color: #fff;
      box-shadow: 0 6px 15px rgba(0,0,0,0.5);
    }
    .card img {
      width: 64px;
      height: 64px;
      object-fit: cover;
      border-radius: 4px;
      margin-top: 8px;
    }
    .points-badge {
      position: absolute;
      top: -10px;
      left: 50%;
      transform: translateX(-50%);
      background: #093f23;
      padding: 4px 10px;
      border-radius: 6px;
      font-weight: bold;
      font-size: 14px;
    }
    .team-name {
      margin-top: 8px;
      font-size: 14px;
    }
    .mgr-name {
      margin-top: 4px;
      font-size: 12px;
      color: #c1f1c3;
    }
    .pos {
      position: absolute;
      transform: translate(-50%, -50%);
    }
    .pos.capt { top: 12%; left: 50%; }
    .pos.left-mid { top: 38%; left: 22%; }
    .pos.center-mid { top: 38%; left: 50%; }
    .pos.right-mid { top: 38%; left: 78%; }
    .pos.striker { top: 70%; left: 50%; }
    .footer {
      background: #05321c;
      padding: 12px 20px;
      display: flex;
      justify-content: space-between;
      align-items: center;
      color: #8ad9a2;
      font-size: 14px;
    }
    .footer .left {
      background: #00b878;
      padding: 6px 12px;
      border-radius: 6px;
      color: #00301b;
      font-weight: bold;
    }
    .footer .right {
      display: flex;
      align-items: center;
      gap: 8px;
    }
    .footer .logo {
      width: 24px;
      height: 24px;
      background: #fff;
      border-radius: 50%;
    }
  </style>
</head>
<body>

<div class="poster">
  <div class="top">
    <div class="left">
      <div class="month-label" id="tom-month">September</div>
      <div class="title-label">5-A-Side</div>
    </div>
    <div class="right" id="tom-total">1,107</div>
  </div>
  <div class="pitch-area">
    <div class="pitch">
      <div class="pos capt" id="pos-capt"></div>
      <div class="pos left-mid" id="pos-left-mid"></div>
      <div class="pos center-mid" id="pos-center-mid"></div>
      <div class="pos right-mid" id="pos-right-mid"></div>
      <div class="pos striker" id="pos-striker"></div>
    </div>
  </div>
  <div class="footer">
    <div class="left">Team of the Month</div>
    <div class="right">
      <span class="logo"></span>
      <span>FPLMAESTROS</span>
    </div>
  </div>
</div>

<script>
function createCardHTML(player) {
  if (!player) return '';
  const logo = player.logo || 'https://via.placeholder.com/64';  
  return `
    <div class="card">
      <div class="points-badge">${player.points}pts</div>
      <img src="${logo}" alt="${player.club} logo" />
      <div class="team-name">${escapeHtml(player.club)}</div>
      <div class="mgr-name">${escapeHtml(player.manager)}</div>
    </div>
  `;
}

function escapeHtml(s) {
  return s ? s.replace(/[&<>"']/g, c => {
    return {'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;'}[c];
  }) : '';
}

function renderTeam(data) {
  if (!data) return;
  document.getElementById('tom-month').textContent = data.month || '';
  document.getElementById('tom-total').textContent = (data.total || 0).toLocaleString();

  document.getElementById('pos-capt').innerHTML = createCardHTML(data.players.capt);
  document.getElementById('pos-left-mid').innerHTML = createCardHTML(data.players.midLeft);
  document.getElementById('pos-center-mid').innerHTML = createCardHTML(data.players.midCenter);
  document.getElementById('pos-right-mid').innerHTML = createCardHTML(data.players.midRight);
  document.getElementById('pos-striker').innerHTML = createCardHTML(data.players.striker);
}

// example data to test
const example = {
  month: "September",
  total: 1107,
  players: {
    capt: { points: 237, club: "Chikuruz FC", manager: "Dino Squad", logo: "https://via.placeholder.com/64/006600" },
    midLeft: { points: 226, club: "Can’t get any wirtz", manager: "D’Intellectuals", logo: "https://via.placeholder.com/64/004d00" },
    midCenter: { points: 216, club: "Segzey FC", manager: "The Fanatics B", logo: "https://via.placeholder.com/64/008000" },
    midRight: { points: 217, club: "Seventh leaf", manager: "Dino Squad", logo: "https://via.placeholder.com/64/007300" },
    striker: { points: 211, club: "3 wild N Rhums", manager: "5 pillars of pain", logo: "https://via.placeholder.com/64/003f00" }
  }
};
renderTeam(example);
</script>

</body>
</html>
