<!DOCTYPE html>
<html lang="en" class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" dir="ltr" data-theme="theme-default" data-assets-path="assets/" data-template="vertical-menu-template" data-style="light">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>League Table | FPL Maestros</title>
    <?php include('nav.php') ?>
    <style>
        .league-table {
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
        }

        .table-header {
            /* background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); */
            color: white;
            padding: 1.5rem;
            border-bottom: none;
        }

        .table-header h5 {
            margin: 0;
            font-weight: 600;
        }

        .table thead th {
            background-color: #f8f9fa;
            border-bottom: 2px solid #e9ecef;
            font-weight: 600;
            color: #2d3748;
            padding: 1rem 0.75rem;
            font-size: 0.875em;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .table tbody tr {
            transition: all 0.3s ease;
            border-bottom: 1px solid #f1f3f4;
        }

        .table tbody tr:hover {
            background-color: #f8f9fa;
            transform: translateY(-1px);
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        }

        .team-cell {
            display: flex;
            align-items: center;
            gap: 12px;
            font-weight: 600;
            color: #2d3748;
        }

        .team-logo {
            width: 32px;
            height: 32px;
            object-fit: contain;
            border-radius: 6px;
            background: white;
            padding: 2px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .position-cell {
            font-weight: 700;
            text-align: center;
            color: #4a5568;
        }

        .stats-cell {
            text-align: center;
            font-weight: 500;
            color: #4a5568;
        }

        .points-cell {
            text-align: center;
            font-weight: 700;
            color: #2d3748;
            background-color: #f7fafc;
        }

        /* Position indicators */
        tr:nth-child(1) .position-cell {
            background: linear-gradient(135deg, #FFD700, #FFED4E);
            color: #856404;
            border-radius: 50%;
            width: 32px;
            height: 32px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto;
        }

        tr:nth-child(2) .position-cell,
        tr:nth-child(3) .position-cell,
        tr:nth-child(4) .position-cell {
            background: #e3f2fd;
            color: #1976d2;
            border-radius: 50%;
            width: 28px;
            height: 28px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto;
        }

        /* Relegation zone */
        tr:nth-last-child(-n+3) .position-cell {
            background: #ffebee;
            color: #c53030;
            border-radius: 50%;
            width: 28px;
            height: 28px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto;
        }

        .goal-difference {
            font-weight: 600;
            color: #48bb78;
        }

        .goal-difference.negative {
            color: #e53e3e;
        }

        .form-indicator {
            display: inline-block;
            width: 8px;
            height: 8px;
            border-radius: 50%;
            margin-right: 4px;
        }

        .form-win {
            background-color: #48bb78;
        }

        .form-draw {
            background-color: #ed8936;
        }

        .form-loss {
            background-color: #e53e3e;
        }

        .table-container {
            position: relative;
        }

        .loading-overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(255, 255, 255, 0.9);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 10;
        }

        .division-badge {
            background: rgba(255, 255, 255, 0.2);
            padding: 0.25rem 0.75rem;
            border-radius: 20px;
            font-size: 0.875em;
            margin-left: 1rem;
        }

        @media (max-width: 768px) {
            .table-responsive {
                font-size: 0.875em;
            }

            .team-cell {
                gap: 8px;
            }

            .team-logo {
                width: 24px;
                height: 24px;
            }

            .table thead th,
            .table tbody td {
                padding: 0.75rem 0.5rem;
            }
        }
    </style>
</head>

<body>
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <!-- League Table Card -->
            <div class="card league-table">
                <div class="table-header d-flex justify-content-between align-items-center">
                    <div class="d-flex align-items-center">
                        <h5 class="mb-0">Division 3 League Table</h5>
                    </div>
                </div>

                <div class="table-container">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0" id="leagueTable">
                            <thead>
                                <tr>
                                    <th width="60" class="text-center">#</th>
                                    <th>Team</th>
                                    <th width="70" class="text-center">P</th>
                                    <th width="70" class="text-center">W</th>
                                    <th width="70" class="text-center">D</th>
                                    <th width="70" class="text-center">L</th>
                                    <th width="70" class="text-center">GF</th>
                                    <th width="70" class="text-center">GA</th>
                                    <th width="80" class="text-center">GD</th>
                                    <th width="90" class="text-center">Pts</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Data will be loaded via AJAX -->
                            </tbody>
                        </table>
                    </div>


                </div>

            </div>
            <div class="loading-overlay card" id="loadingOverlay">
                <div class="text-center">
                    <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                    <p class="mt-2 mb-0">Loading league table...</p>
                </div>
            </div>
        </div>
    </div>
    <!-- / Content -->

    <?php include('footer.php') ?>

    <script>
        function refreshLeagueTable() {
            $('#loadingOverlay').show();

            $.ajax({
                url: "connect.php",
                method: "GET",
                data: {
                    refreshLeagueTable: "Yes",
                    division: 3
                },
                success: function(data) {
                    let html = "";
                    let pos = 1;

                    if (data && Array.isArray(data)) {
                        data.forEach(row => {
                            const goalDiff = parseInt(row.goal_difference);
                            const goalDiffClass = goalDiff >= 0 ? 'goal-difference' : 'goal-difference negative';
                            const goalDiffDisplay = goalDiff > 0 ? `+${goalDiff}` : goalDiff;

                            html += `
                                <tr>
                                    <td>${pos}</td>
                                    <td>
                                        <div class="team-cell">
                                            <img src="uploads/${row.logo}" 
                                                 onerror="this.src='assets/img/avatars/1.png'" 
                                                 alt="${row.team_name}" 
                                                 class="team-logo">
                                            <span>${row.team_name}</span>
                                        </div>
                                    </td>
                                    <td class="stats-cell">${row.played}</td>
                                    <td class="stats-cell">${row.won}</td>
                                    <td class="stats-cell">${row.drawn}</td>
                                    <td class="stats-cell">${row.lost}</td>
                                    <td class="stats-cell">${row.goals_for}</td>
                                    <td class="stats-cell">${row.goals_against}</td>
                                    <td class="stats-cell ${goalDiffClass}">${goalDiffDisplay}</td>
                                    <td class="points-cell"><strong>${row.points}</strong></td>
                                </tr>`;
                            pos++;
                        });
                    } else {
                        html = `<tr><td colspan="10" class="text-center py-4 text-muted">No data available</td></tr>`;
                    }

                    $("#leagueTable tbody").html(html);
                    $('#loadingOverlay').hide();
                },
                error: function() {
                    $("#leagueTable tbody").html(`
                            <tr>
                                <td colspan="10" class="text-center py-4 text-muted">
                                    <i class="bx bx-error"></i><br>
                                    Failed to load data
                                </td>
                            </tr>
                        `);
                    $('#loadingOverlay').hide();
                }
            });
        }

        // Refresh on page load
        $(document).ready(function() {
            refreshLeagueTable();

            // Auto-refresh every 60 seconds
            // setInterval(refreshLeagueTable, 60000);
        });
    </script>
    </div>
</body>

</html>