<!DOCTYPE html>
<html lang="en" class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" dir="ltr" data-theme="theme-default" data-assets-path="assets/" data-template="vertical-menu-template" data-style="light">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>Results | FPL Maestros</title>
    <?php include('nav.php') ?>

    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <form method="POST">
            <div class="container-xxl flex-grow-1 container-p-y">
                <div class="row">
                    <!-- Main Fixtures Column -->
                    <div class="col-12 col-lg-8 mb-4">
                        <div class="card">
                            <div class="card-body">
                                <div class="container-fluid">
                                    <!-- Gameweek Selector - Mobile Optimized -->
                                    <div class="d-flex flex-column flex-sm-row justify-content-between align-items-start align-items-sm-center mb-3 gap-2">
                                        <h4 class="mb-0" id="gw-title">Gameweek Fixtures</h4>
                                        <select class="form-select w-auto" id="gw-select" style="min-width: 150px;">
                                            <option>Gameweek 1</option>
                                            <option>Gameweek 2</option>
                                            <option>Gameweek 3</option>
                                            <option selected>Gameweek 4</option>
                                        </select>
                                    </div>
                                    
                                    <div id="loader" style="display:none; text-align:center;">
                                        <div class="spinner-border text-primary" role="status">
                                            <span class="visually-hidden">Loading...</span>
                                        </div>
                                    </div>
                                    
                                    <div id="fixtures-container">
                                        <!-- Fixtures will be loaded here -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <?php 
                    $sq = $db->query("SELECT * FROM results WHERE division = 1 ORDER BY gameweek DESC LIMIT 1");
                    if (mysqli_num_rows($sq) < 1) {
                    ?>
                        <input type="hidden" id="gw-no" value="1">
                    <?php
                    } else {
                        $fetch = mysqli_fetch_assoc($sq); ?>
                        <input type="hidden" id="gw-no" value="<?= $fetch['gameweek'] ?>">
                    <?php } ?>

                    <!-- Goalscorers Column - Stack on mobile -->
                    <div class="col-12 col-lg-4">
                        <div class="card">
                            <div class="card-body">
                                <div class="container-fluid">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <h4 class="mb-0">Goalscorers</h4>
                                    </div>
                                    <div id="goalscorers-container" class="mt-3">
                                        <div class="table-responsive">
                                            <table id="goalscorers-table" class="table table-hover align-middle mb-0">
                                                <thead class="table-light">
                                                    <tr>
                                                        <th>Manager</th>
                                                        <th class="text-end">Goals</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="gs-table">
                                                    <!-- Goalscorers will be loaded here -->
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
        <!-- / Content -->

        <script>
            $(document).ready(function() {
                function updateManagerHistories() {
                    return $.ajax({
                        method: "POST",
                        url: "connect.php",
                        data: {
                            updateManagerHistories: "YES"
                        }
                    });
                }

                function updateAllResults() {
                    return $.ajax({
                        method: "POST",
                        url: "connect.php",
                        data: {
                            updateAllResults: "YES"
                        }
                    });
                }

                function getFixtures() {
                    return $.ajax({
                        method: "GET",
                        url: "connect.php",
                        data: {
                            get_fixt_details: "Yes",
                            division: 1
                        }
                    });
                }

                getFixtures().then((data) => {
                        console.log("Fixtures:", data);

                        let select = $("#gw-select").empty();
                        let fixtureContainer = $("#fixtures-container");
                        let initGw = $("#gw-no").val();

                        // Populate dropdown
                        Object.keys(data).forEach((gw, index) => {
                            let opt = $("<option></option>").val(gw).text("GW " + gw);
                            if (index === (initGw - 1)) opt.prop("selected", true);
                            select.append(opt);
                        });

                        // Load first gameweek fixtures initially
                        let firstGw = Object.keys(data)[0];
                        getResults(initGw);
                        getGoalscorers(initGw);

                        // Handle change
                        select.on("change", function() {
                            let gw = $(this).val();
                            getResults(gw);
                            getGoalscorers(gw);
                        });
                    })
                    .catch((err) => {
                        console.error("Error:", err);
                    });
            });

            function renderFixtures(gw, fixtures) {
                $("#gw-title").text("Gameweek " + gw + " Fixtures");
                let fixtureContainer = $("#fixtures-container").empty();

                fixtures.forEach(f => {
                    let homeManagers = f.home_managers.map(m => `
                        <div class="d-flex justify-content-between align-items-center py-1 border-bottom">
                            <div class="flex-grow-1">
                                <a href="https://fantasy.premierleague.com/entry/${m.id}/event/${gw}"
                                    id="manager-${m.id}"
                                    class="text-dark text-decoration-none"
                                    target="_blank">
                                    <small class="fw-medium">${m.name}</small>
                                </a>
                            </div>
                            <div class="text-end">
                                <small class="text-muted">${m.points}(-${m.transfer_cost})=<strong>${m.net_points}</strong></small>
                            </div>
                        </div>
                    `).join("");

                    let awayManagers = f.away_managers.map(m => `
                        <div class="d-flex justify-content-between align-items-center py-1 border-bottom">
                            <div class="flex-grow-1">
                                <a href="https://fantasy.premierleague.com/entry/${m.id}/event/${gw}"
                                    id="manager-${m.id}"
                                    class="text-dark text-decoration-none"
                                    target="_blank">
                                    <small class="fw-medium">${m.name}</small>
                                </a>
                            </div>
                            <div class="text-end">
                                <small class="text-muted">${m.points}(-${m.transfer_cost})=<strong>${m.net_points}</strong></small>
                            </div>
                        </div>
                    `).join("");

                    // Results straight from DB
                    let teamTotals = `<span class="text-primary fw-bold">${f.home_points ?? 0}</span> : <span class="text-primary fw-bold">${f.away_points ?? 0}</span>`;
                    let teamGoals = `<span class="text-success fw-bold fs-6">${f.home_goals ?? '-'}</span> : <span class="text-success fw-bold fs-6">${f.away_goals ?? '-'}</span>`;
                    let statusBadge = "";

                    if (f.status === "Closed") {
                        statusBadge = `<span class="badge bg-secondary">Closed</span>`;
                    } else if (f.status === "Live") {
                        statusBadge = `<span class="badge bg-success">Live</span>`;
                    } else {
                        statusBadge = `<span class="badge bg-warning text-dark">Pending</span>`;
                    }

                    let card = `
<div class="card mb-3 border">
    <!-- Header with status -->
    <div class="card-header d-flex justify-content-between align-items-center py-2">
        <div class="d-flex align-items-center">
            ${statusBadge}
        </div>
        <a href="#fixtureDetails${f.fixture_id}" class="btn btn-sm btn-outline-primary p-1" data-bs-toggle="collapse" aria-expanded="false" aria-controls="fixtureDetails${f.fixture_id}">
            <i class="tf-icons ri-arrow-down-s-line"></i>
        </a>
    </div>

    <!-- Main fixture content - Mobile optimized -->
    <div class="card-body p-3">
        <!-- Home Team -->
        <div class="row align-items-center g-2">
            <div class="col-5">
                <div class="d-flex flex-column align-items-center text-center">
                    <img src="uploads/${f.home_logo}"
                        onerror="this.src='assets/img/avatars/1.png'"
                        alt="${f.home_team}" 
                        class="mb-1"
                        style="height: 40px; width: 34px; object-fit: contain;">
                    <span class="small fw-medium text-truncate w-100">${f.home_team}</span>
                </div>
            </div>

            <!-- Score -->
            <div class="col-2 text-center">
                <div class="mb-1">${teamGoals}</div>
                <div class="small text-muted">${teamTotals}</div>
            </div>

            <!-- Away Team -->
            <div class="col-5">
                <div class="d-flex flex-column align-items-center text-center">
                    <img src="uploads/${f.away_logo}"
                        onerror="this.src='assets/img/avatars/1.png'"
                        alt="${f.away_team}" 
                        class="mb-1"
                        style="height: 40px; width: 34px; object-fit: contain;">
                    <span class="small fw-medium text-truncate w-100">${f.away_team}</span>
                </div>
            </div>
        </div>

        <!-- Explanation (if any) -->
        ${f.explanation ? `
        <div id="fixture-exp-${f.fixture_id}" class="text-center mt-2 p-2 bg-light rounded small">
            ${f.explanation}
        </div>
        ` : ''}
    </div>

    <!-- Collapsible Manager Details - Mobile Optimized -->
    <div id="fixtureDetails${f.fixture_id}" class="collapse">
        <div class="card-body border-top p-3">
            <div class="row g-3">
                <!-- Home Managers -->
                <div class="col-12 col-sm-6">
                    <h6 class="small fw-bold text-primary mb-2">Home Managers</h6>
                    <div class="small">
                        ${homeManagers}
                        <div class="d-flex justify-content-between align-items-center pt-2 mt-2 border-top">
                            <span class="fw-bold">Total:</span>
                            <span class="fw-bold text-primary">${f.home_points ?? 0}</span>
                        </div>
                    </div>
                </div>
                
                <!-- Away Managers -->
                <div class="col-12 col-sm-6">
                    <h6 class="small fw-bold text-danger mb-2">Away Managers</h6>
                    <div class="small">
                        ${awayManagers}
                        <div class="d-flex justify-content-between align-items-center pt-2 mt-2 border-top">
                            <span class="fw-bold">Total:</span>
                            <span class="fw-bold text-danger">${f.away_points ?? 0}</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
`;

                    fixtureContainer.append(card);
                });
            }

            function getResults(gw) {
                $.ajax({
                    method: "GET",
                    url: "connect.php",
                    data: {
                        getFixturesWithResults: "YES",
                        gw: gw,
                        division: 3
                    }
                }).done(function(data) {
                    fixtures = data;
                    renderFixtures(gw, data);
                }).fail(function() {
                    console.log('error');
                });
            }

            function getGoalscorers(gw) {
                $.ajax({
                    method: "GET",
                    url: "connect.php",
                    data: {
                        getGoalscorers: "YES",
                        gw: gw,
                        division: 3
                    }
                }).done(function(data) {
                    let gstable = $("#gs-table").empty();
                    data.forEach(f => {
                        let row = `<tr>
                            <td>
                                <div class="d-flex flex-column">
                                    <span class="fw-medium">${f.manager_name}</span>
                                    <small class="text-muted">${f.manager_team}</small>
                                </div>
                            </td>
                            <td class="text-end">
                                <span>1</span>
                            </td>
                        </tr>`;
                        gstable.append(row);
                    });
                }).fail(function() {
                    console.log('error');
                });
            }
        </script>

        <?php include('footer.php') ?>
</body>
</html>