<!DOCTYPE html>
<html lang="en" class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" dir="ltr" data-theme="theme-default" data-assets-path="assets/" data-template="vertical-menu-template" data-style="light">

<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
  <title>Dashboard | FPL Maestros</title>
  <?php include('nav.php') ?>

  <?php
  // Function to get team form
  function getTeamForm($team_id, $number_of_games = 5)
  {
    global $db;

    $form = array();

    $recent_results = $db->query("
          SELECT 
              CASE 
                  WHEN home_team = $team_id AND home_goals > away_goals THEN 'W'
                  WHEN away_team = $team_id AND away_goals > home_goals THEN 'W'
                  WHEN home_goals = away_goals THEN 'D'
                  ELSE 'L'
              END as result
          FROM results 
          WHERE (home_team = $team_id OR away_team = $team_id) 
          AND status = 'Closed'
          ORDER BY gameweek DESC 
          LIMIT $number_of_games
      ");

    while ($result = $recent_results->fetch_assoc()) {
      $form[] = $result['result'];
    }

    return array_reverse($form);
  }

  $sq = $db->query("SELECT * FROM results ORDER BY gameweek DESC LIMIT 1");
  $fetch = mysqli_fetch_assoc($sq);
  $gw_no = $fetch['gameweek'];
  $current_season = '2025';
  ?>

  <!-- Content wrapper -->
  <div class="content-wrapper">
    <div class="container-xxl flex-grow-1 container-p-y">

      <!-- Gameweek Overview Cards -->
      <div class="row g-4 mb-4">
        <!-- Current Gameweek -->
        <div class="col-sm-6 col-xl-3">
          <div class="card">
            <div class="card-body">
              <div class="d-flex justify-content-between">
                <div class="me-2">
                  <p class="text-heading mb-1">Current Gameweek</p>
                  <h4 class="mb-1">GW <?= $gw_no ?></h4>
                  <small class="text-muted">
                    <?php
                    $gwStatuses = $pro->getAllGwStatuses();
                    echo $gwStatuses[$gw_no];
                    ?>
                  </small>
                </div>
                <div class="avatar">
                  <div class="avatar-initial bg-label-primary rounded">
                    <i class="ri-calendar-line ri-24px"></i>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <!-- Total Teams -->
        <div class="col-sm-6 col-xl-3">
          <div class="card">
            <div class="card-body">
              <div class="d-flex justify-content-between">
                <div class="me-2">
                  <p class="text-heading mb-1">Total Teams</p>
                  <?php
                  $team_count = $db->query("SELECT COUNT(*) as total FROM teams")->fetch_assoc()['total'];
                  ?>
                  <h4 class="mb-1"><?= $team_count ?></h4>
                  <small class="text-muted">Across 3 divisions</small>
                </div>
                <div class="avatar">
                  <div class="avatar-initial bg-label-info rounded">
                    <i class="ri-team-line ri-24px"></i>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <!-- Total Goals -->
        <div class="col-sm-6 col-xl-3">
          <div class="card">
            <div class="card-body">
              <div class="d-flex justify-content-between">
                <div class="me-2">
                  <p class="text-heading mb-1">Total Goals</p>
                  <?php
                  $goals_data = $db->query("SELECT SUM(goals_for) as total_goals, SUM(played) as total_matches FROM league_table")->fetch_assoc();
                  ?>
                  <h4 class="mb-1"><?= $goals_data['total_goals'] ?></h4>
                  <small class="text-muted">
                    <?= number_format($goals_data['total_goals'] / max($goals_data['total_matches'], 1), 2) ?> per match
                  </small>
                </div>
                <div class="avatar">
                  <div class="avatar-initial bg-label-success rounded">
                    <i class="ri-football-line ri-24px"></i>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        <!-- Top Team -->
        <div class="col-sm-6 col-xl-3">
          <div class="card">
            <div class="card-body">
              <div class="d-flex justify-content-between">
                <div class="me-2">
                  <p class="text-heading mb-1">Div 1 League Leader</p>
                  <?php
                  $top_team = $db->query("
                    SELECT t.team_name, l.points 
                    FROM league_table l 
                    JOIN teams t ON t.id = l.team_id 
                    ORDER BY (l.points*1) DESC, (l.goal_difference*1) DESC 
                    LIMIT 1
                  ")->fetch_assoc();
                  ?>
                  <h4 class="mb-1"><?= $top_team['team_name'] ?? 'N/A' ?></h4>
                  <small class="text-muted"><?= $top_team['points'] ?? 0 ?> points</small>
                </div>
                <div class="avatar">
                  <div class="avatar-initial bg-label-warning rounded">
                    <i class="ri-trophy-line ri-24px"></i>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <!-- Main Content Grid -->
      <div class="row g-4">

        <!-- Division Standings -->
        <div class="col-xl-8">
          <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
              <h5 class="mb-0">Division Standings</h5>
              <div class="btn-group">
                <button type="button" class="btn btn-outline-primary btn-sm active" data-division="1">Div 1</button>
                <button type="button" class="btn btn-outline-primary btn-sm" data-division="2">Div 2</button>
                <button type="button" class="btn btn-outline-primary btn-sm" data-division="3">Div 3</button>
              </div>
            </div>
            <div class="card-body">
              <div id="division-1" class="division-table">
                <?php displayDivisionTable(1); ?>
              </div>
              <div id="division-2" class="division-table d-none">
                <?php displayDivisionTable(2); ?>
              </div>
              <div id="division-3" class="division-table d-none">
                <?php displayDivisionTable(3); ?>
              </div>
            </div>
          </div>

          <!-- Team Rankings by Points -->
          <div class="card mt-4">
            <div class="card-header d-flex justify-content-between align-items-center">
              <h5 class="mb-0">Team Rankings by Points</h5>
              <div class="btn-group">
                <button type="button" class="btn btn-outline-primary btn-sm active" data-division="1">Div 1</button>
                <button type="button" class="btn btn-outline-primary btn-sm" data-division="2">Div 2</button>
                <button type="button" class="btn btn-outline-primary btn-sm" data-division="3">Div 3</button>
              </div>
            </div>
            <div class="card-body">
              <!-- Division 1 Rankings -->
              <div id="rankings-division-1" class="rankings-table">
                <div class="text-center py-4">
                  <div class="spinner-border text-primary" role="status"></div>
                  <p class="mt-2 mb-0 text-muted">Loading rankings...</p>
                </div>
              </div>

              <!-- Division 2 Rankings -->
              <div id="rankings-division-2" class="rankings-table d-none">
                <div class="text-center py-4">
                  <div class="spinner-border text-primary" role="status"></div>
                  <p class="mt-2 mb-0 text-muted">Loading rankings...</p>
                </div>
              </div>

              <!-- Division 3 Rankings -->
              <div id="rankings-division-3" class="rankings-table d-none">
                <div class="text-center py-4">
                  <div class="spinner-border text-primary" role="status"></div>
                  <p class="mt-2 mb-0 text-muted">Loading rankings...</p>
                </div>
              </div>
            </div>
          </div>
        </div>

        <!-- Sidebar Content -->
        <div class="col-xl-4">

          <!-- Team of the Week by Division -->
          <div class="card">
            <div class="card-header">
              <h5 class="mb-0">Team of the Week - GW<?= $gw_no ?></h5>
            </div>
            <div class="card-body">
              <!-- Division 1 Team of the Week -->
              <div class="mb-4">
                <h6 class="text-primary mb-2">Division 1</h6>
                <?php
                $team_of_week_div1 = $db->query("
                  SELECT mh.manager_id, mh.net_points, t.team_name, t.logo
                  FROM manager_history mh 
                  JOIN teams t ON FIND_IN_SET(mh.manager_id, CONCAT(t.manager1, ',', t.manager2, ',', t.manager3, ',', t.manager4, ',', t.manager5)) > 0
                  JOIN league_table lt ON lt.team_id = t.id
                  WHERE mh.event = $gw_no AND lt.division = 1
                  ORDER BY mh.net_points DESC 
                  LIMIT 5
                ");

                $rank = 1;
                while ($manager = $team_of_week_div1->fetch_assoc()):
                ?>
                  <div class="d-flex align-items-center mb-2">
                    <div class="avatar avatar-sm me-2">
                      <span class="avatar-initial rounded bg-label-primary"><?= $rank ?></span>
                    </div>
                    <div class="flex-grow-1">
                      <div class="d-flex align-items-center">
                        <span class="team-logo me-2">
                          <img src="uploads/<?= $manager['logo'] ?>" onerror="this.src='assets/img/avatars/1.png'" alt="<?= $manager['team_name'] ?>" style="height: 20px; width: 20px; object-fit: contain;">
                        </span>
                        <h6 class="mb-0 small"><?= getFplTeamNameFromDb($manager['manager_id']) ?></h6>
                      </div>
                      <small class="text-muted"><?= $manager['team_name'] ?> • <?= $manager['net_points'] ?> pts</small>
                    </div>
                  </div>
                <?php $rank++;
                endwhile; ?>
              </div>

              <!-- Division 2 Team of the Week -->
              <div class="mb-4">
                <h6 class="text-success mb-2">Division 2</h6>
                <?php
                $team_of_week_div2 = $db->query("
                  SELECT mh.manager_id, mh.net_points, t.team_name, t.logo
                  FROM manager_history mh 
                  JOIN teams t ON FIND_IN_SET(mh.manager_id, CONCAT(t.manager1, ',', t.manager2, ',', t.manager3, ',', t.manager4, ',', t.manager5)) > 0
                  JOIN league_table lt ON lt.team_id = t.id
                  WHERE mh.event = $gw_no AND lt.division = 2
                  ORDER BY mh.net_points DESC 
                  LIMIT 5
                ");

                $rank = 1;
                while ($manager = $team_of_week_div2->fetch_assoc()):
                ?>
                  <div class="d-flex align-items-center mb-2">
                    <div class="avatar avatar-sm me-2">
                      <span class="avatar-initial rounded bg-label-success"><?= $rank ?></span>
                    </div>
                    <div class="flex-grow-1">
                      <div class="d-flex align-items-center">
                        <span class="team-logo me-2">
                          <img src="uploads/<?= $manager['logo'] ?>" onerror="this.src='assets/img/avatars/1.png'" alt="<?= $manager['team_name'] ?>" style="height: 20px; width: 20px; object-fit: contain;">
                        </span>
                        <h6 class="mb-0 small"><?= getFplTeamNameFromDb($manager['manager_id']) ?></h6>
                      </div>
                      <small class="text-muted"><?= $manager['team_name'] ?> • <?= $manager['net_points'] ?> pts</small>
                    </div>
                  </div>
                <?php $rank++;
                endwhile; ?>
              </div>

              <!-- Division 3 Team of the Week -->
              <div class="mb-2">
                <h6 class="text-warning mb-2">Division 3</h6>
                <?php
                $team_of_week_div3 = $db->query("
                  SELECT mh.manager_id, mh.net_points, t.team_name, t.logo
                  FROM manager_history mh 
                  JOIN teams t ON FIND_IN_SET(mh.manager_id, CONCAT(t.manager1, ',', t.manager2, ',', t.manager3, ',', t.manager4, ',', t.manager5)) > 0
                  JOIN league_table lt ON lt.team_id = t.id
                  WHERE mh.event = $gw_no AND lt.division = 3
                  ORDER BY mh.net_points DESC 
                  LIMIT 5
                ");

                $rank = 1;
                while ($manager = $team_of_week_div3->fetch_assoc()):
                ?>
                  <div class="d-flex align-items-center mb-2">
                    <div class="avatar avatar-sm me-2">
                      <span class="avatar-initial rounded bg-label-warning"><?= $rank ?></span>
                    </div>
                    <div class="flex-grow-1">
                      <div class="d-flex align-items-center">
                        <span class="team-logo me-2">
                          <img src="uploads/<?= $manager['logo'] ?>" onerror="this.src='assets/img/avatars/1.png'" alt="<?= $manager['team_name'] ?>" style="height: 20px; width: 20px; object-fit: contain;">
                        </span>
                        <h6 class="mb-0 small"><?= getFplTeamNameFromDb($manager['manager_id']) ?></h6>
                      </div>
                      <small class="text-muted"><?= $manager['team_name'] ?> • <?= $manager['net_points'] ?> pts</small>
                    </div>
                  </div>
                <?php $rank++;
                endwhile; ?>
              </div>
            </div>
          </div>

          <!-- Top Goalscorers by Division -->
          <div class="card mt-4">
            <div class="card-header">
              <h5 class="mb-0">Top Goalscorers</h5>
            </div>
            <div class="card-body">
              <!-- Division 1 Top Scorers -->
              <div class="mb-4">
                <h6 class="text-primary mb-2">Division 1</h6>
                <?php
                $top_scorers_div1 = $db->query("
                  SELECT g.manager_id, SUM(g.goals) as total_goals, t.team_name, t.logo
                  FROM goalscorers g 
                  JOIN teams t ON g.team_id = t.id 
                  JOIN league_table lt ON lt.team_id = t.id
                  WHERE lt.division = 1
                  GROUP BY g.manager_id, t.team_name, t.logo
                  ORDER BY total_goals DESC 
                  LIMIT 3
                ");

                $rank = 1;
                while ($scorer = $top_scorers_div1->fetch_assoc()):
                ?>
                  <div class="d-flex align-items-center mb-2">
                    <div class="avatar avatar-sm me-2">
                      <span class="avatar-initial rounded bg-label-danger"><?= $rank ?></span>
                    </div>
                    <div class="flex-grow-1">
                      <div class="d-flex align-items-center">
                        <span class="team-logo me-2">
                          <img src="uploads/<?= $scorer['logo'] ?>" onerror="this.src='assets/img/avatars/1.png'" alt="<?= $scorer['team_name'] ?>" style="height: 20px; width: 20px; object-fit: contain;">
                        </span>
                        <h6 class="mb-0 small"><?= getFplTeamNameFromDb($scorer['manager_id']) ?></h6>
                      </div>
                      <small class="text-muted"><?= $scorer['team_name'] ?> • <?= $scorer['total_goals'] ?> goals</small>
                    </div>
                  </div>
                <?php $rank++;
                endwhile; ?>
              </div>

              <!-- Division 2 Top Scorers -->
              <div class="mb-4">
                <h6 class="text-success mb-2">Division 2</h6>
                <?php
                $top_scorers_div2 = $db->query("
                  SELECT g.manager_id, SUM(g.goals) as total_goals, t.team_name, t.logo
                  FROM goalscorers g 
                  JOIN teams t ON g.team_id = t.id 
                  JOIN league_table lt ON lt.team_id = t.id
                  WHERE lt.division = 2
                  GROUP BY g.manager_id, t.team_name, t.logo
                  ORDER BY total_goals DESC 
                  LIMIT 3
                ");

                $rank = 1;
                while ($scorer = $top_scorers_div2->fetch_assoc()):
                ?>
                  <div class="d-flex align-items-center mb-2">
                    <div class="avatar avatar-sm me-2">
                      <span class="avatar-initial rounded bg-label-danger"><?= $rank ?></span>
                    </div>
                    <div class="flex-grow-1">
                      <div class="d-flex align-items-center">
                        <span class="team-logo me-2">
                          <img src="uploads/<?= $scorer['logo'] ?>" onerror="this.src='assets/img/avatars/1.png'" alt="<?= $scorer['team_name'] ?>" style="height: 20px; width: 20px; object-fit: contain;">
                        </span>
                        <h6 class="mb-0 small"><?= getFplTeamNameFromDb($scorer['manager_id']) ?></h6>
                      </div>
                      <small class="text-muted"><?= $scorer['team_name'] ?> • <?= $scorer['total_goals'] ?> goals</small>
                    </div>
                  </div>
                <?php $rank++;
                endwhile; ?>
              </div>

              <!-- Division 3 Top Scorers -->
              <div class="mb-2">
                <h6 class="text-warning mb-2">Division 3</h6>
                <?php
                $top_scorers_div3 = $db->query("
                  SELECT g.manager_id, SUM(g.goals) as total_goals, t.team_name, t.logo
                  FROM goalscorers g 
                  JOIN teams t ON g.team_id = t.id 
                  JOIN league_table lt ON lt.team_id = t.id
                  WHERE lt.division = 3
                  GROUP BY g.manager_id, t.team_name, t.logo
                  ORDER BY total_goals DESC 
                  LIMIT 3
                ");

                $rank = 1;
                while ($scorer = $top_scorers_div3->fetch_assoc()):
                ?>
                  <div class="d-flex align-items-center mb-2">
                    <div class="avatar avatar-sm me-2">
                      <span class="avatar-initial rounded bg-label-danger"><?= $rank ?></span>
                    </div>
                    <div class="flex-grow-1">
                      <div class="d-flex align-items-center">
                        <span class="team-logo me-2">
                          <img src="uploads/<?= $scorer['logo'] ?>" onerror="this.src='assets/img/avatars/1.png'" alt="<?= $scorer['team_name'] ?>" style="height: 20px; width: 20px; object-fit: contain;">
                        </span>
                        <h6 class="mb-0 small"><?= getFplTeamNameFromDb($scorer['manager_id']) ?></h6>
                      </div>
                      <small class="text-muted"><?= $scorer['team_name'] ?> • <?= $scorer['total_goals'] ?> goals</small>
                    </div>
                  </div>
                <?php $rank++;
                endwhile; ?>
              </div>
            </div>
          </div>

          <!-- Upcoming Fixtures -->
          <!-- <div class="card mt-4">
            <div class="card-header">
              <h5 class="mb-0">Upcoming Fixtures - GW<?= $gw_no + 1 ?></h5>
            </div>
            <div class="card-body">
              <?php
              $next_gw = $gw_no + 1;
              $upcoming_fixtures = $db->query("
                SELECT f.*, ht.team_name as home_name, at.team_name as away_name, ht.logo as home_logo, at.logo as away_logo
                FROM fixtures f 
                JOIN teams ht ON f.home_team_id = ht.id 
                JOIN teams at ON f.away_team_id = at.id 
                WHERE f.gameweek = $next_gw 
                ORDER BY f.division 
                LIMIT 6
              ");

              while ($fixture = $upcoming_fixtures->fetch_assoc()):
              ?>
              <div class="fixture-item mb-3 pb-2 border-bottom">
                <div class="d-flex justify-content-between align-items-center mb-1">
                  <small class="text-muted">Div <?= $fixture['division'] ?></small>
                </div>
                <div class="d-flex justify-content-between align-items-center">
                  <div class="d-flex align-items-center">
                    <span class="team-logo me-2">
                      <img src="uploads/<?= $fixture['home_logo'] ?>" onerror="this.src='assets/img/avatars/1.png'" alt="<?= $fixture['home_name'] ?>" style="height: 20px; width: 20px; object-fit: contain;">
                    </span>
                    <span class="small"><?= $fixture['home_name'] ?></span>
                  </div>
                  <span class="badge bg-label-secondary mx-2">vs</span>
                  <div class="d-flex align-items-center">
                    <span class="team-logo me-2">
                      <img src="uploads/<?= $fixture['away_logo'] ?>" onerror="this.src='assets/img/avatars/1.png'" alt="<?= $fixture['away_name'] ?>" style="height: 20px; width: 20px; object-fit: contain;">
                    </span>
                    <span class="small"><?= $fixture['away_name'] ?></span>
                  </div>
                </div>
              </div>
              <?php endwhile; ?>
              
              <?php if ($upcoming_fixtures->num_rows == 0): ?>
                <p class="text-muted text-center mb-0">No fixtures scheduled</p>
              <?php endif; ?>
            </div>
          </div> -->

        </div>
      </div>

    </div>
  </div>

  <script>
    $(document).ready(function() {
      // Division tabs functionality for standings
      $('.card:first-child .btn-group .btn').on('click', function() {
        $('.card:first-child .btn-group .btn').removeClass('active');
        $(this).addClass('active');

        var division = $(this).data('division');
        $('.division-table').addClass('d-none');
        $('#division-' + division).removeClass('d-none');
      });

      // Division tabs functionality for rankings
      $('.card:nth-child(2) .btn-group .btn').on('click', function() {
        $('.card:nth-child(2) .btn-group .btn').removeClass('active');
        $(this).addClass('active');

        var division = $(this).data('division');
        $('.rankings-table').addClass('d-none');
        $('#rankings-division-' + division).removeClass('d-none');

        // Load rankings for the selected division
        loadDivisionRankings(division);
      });

      // Load initial rankings for Division 1
      loadDivisionRankings(1);

      function loadDivisionRankings(division) {
        const container = $('#rankings-division-' + division);

        container.html(`
        <div class="text-center py-4">
          <div class="spinner-border text-primary" role="status"></div>
          <p class="mt-2 mb-0 text-muted">Loading rankings...</p>
        </div>
      `);

        $.ajax({
          url: "connect.php",
          method: "GET",
          data: {
            getDivTeamRankings: "Yes",
            division: division
          },
          success: function(data) {
            renderRankingsTable(division, data);
          },
          error: function() {
            container.html(`
            <div class="text-center py-4">
              <i class="ri-error-warning-line text-warning ri-2x mb-3"></i>
              <p class="text-muted">Failed to load rankings</p>
            </div>
          `);
          }
        });
      }

      function renderRankingsTable(division, teams) {
        const container = $('#rankings-division-' + division);

        if (!teams || teams.length === 0) {
          container.html(`
          <div class="text-center py-4">
            <i class="ri-information-line text-muted ri-2x mb-3"></i>
            <p class="text-muted">No ranking data available</p>
          </div>
        `);
          return;
        }

        let html = `
        <div class="table-responsive">
          <table class="table table-hover">
            <thead>
              <tr>
                <th width="60">Rank</th>
                <th>Team</th>
                <th width="100" class="text-end">Total Points</th>
              </tr>
            </thead>
            <tbody>`;

        teams.forEach((team, index) => {
          // Add special styling for top 3 teams
          let rowClass = '';
          let rankClass = '';

          // if (index === 0) {
          //   rowClass = 'table-warning';
          //   rankClass = 'text-warning fw-bold';
          // } else if (index === 1) {
          //   rowClass = 'table-light';
          //   rankClass = 'text-secondary fw-bold';
          // } else if (index === 2) {
          //   rowClass = 'table-light';
          //   rankClass = 'text-info fw-bold';
          // }

          html += `
          <tr class="${rowClass}">
            <td>
              <span class="${rankClass}">${team.rank}</span>
            </td>
            <td>
              <strong>${team.team_name}</strong>
            </td>
            <td class="text-end">
              <span class="fw-bold text-primary">${team.total_points}</span>
            </td>
          </tr>`;
        });

        html += `
            </tbody>
          </table>
        </div>`;

        container.html(html);
      }
    });
  </script>

  <?php
  // Helper function to display division tables
  function displayDivisionTable($division)
  {
    global $db;

    $teams = $db->query("
      SELECT t.team_name, t.logo, l.* 
      FROM league_table l 
      JOIN teams t ON t.id = l.team_id 
      WHERE l.division = '$division' 
      ORDER BY (l.points*1) DESC, (l.goal_difference*1) DESC, (l.goals_for*1) DESC
    ");
  ?>
    <div class="table-responsive">
      <table class="table table-hover">
        <thead>
          <tr>
            <th>Pos</th>
            <th>Team</th>
            <th>P</th>
            <th>W</th>
            <th>D</th>
            <th>L</th>
            <th>GF</th>
            <th>GA</th>
            <th>GD</th>
            <th>Pts</th>
            <th>Form</th>
          </tr>
        </thead>
        <tbody>
          <?php
          $position = 1;
          while ($team = $teams->fetch_assoc()):
            $form = getTeamForm($team['team_id'], 5);
          ?>
            <tr>
              <td><strong><?= $position ?></strong></td>
              <td>
                <div class="d-flex align-items-center">
                  <span class="team-logo">
                    <img src="uploads/<?= $team['logo'] ?>" onerror="this.src='assets/img/avatars/1.png'" alt="<?= $team['team_name'] ?>" class="me-2" style="height: 24px; width: 24px; object-fit: contain;">
                  </span>
                  <strong><?= $team['team_name'] ?></strong>
                </div>
              </td>
              <td><?= $team['played'] ?></td>
              <td><?= $team['won'] ?></td>
              <td><?= $team['drawn'] ?></td>
              <td><?= $team['lost'] ?></td>
              <td><?= $team['goals_for'] ?></td>
              <td><?= $team['goals_against'] ?></td>
              <td>
                <span class="<?= $team['goal_difference'] >= 0 ? 'text-success' : 'text-danger' ?>">
                  <?= $team['goal_difference'] > 0 ? '+' : '' ?><?= $team['goal_difference'] ?>
                </span>
              </td>
              <td><strong><?= $team['points'] ?></strong></td>
              <td>
                <?php if (!empty($form)): ?>
                  <div class="d-flex" style="gap: 2px;">
                    <?php foreach ($form as $result): ?>
                      <span class="badge bg-<?= $result == 'W' ? 'success' : ($result == 'D' ? 'warning' : 'danger') ?>" style="padding: 4px 6px; font-size: 10px;">
                        <?= $result ?>
                      </span>
                    <?php endforeach; ?>
                  </div>
                <?php else: ?>
                  <span class="text-muted">-</span>
                <?php endif; ?>
              </td>
            </tr>
          <?php
            $position++;
          endwhile;
          ?>
        </tbody>
      </table>
    </div>
  <?php
  }
  ?>

  <?php include('footer.php') ?>
  </body>

</html>