<!DOCTYPE html>
<html lang="en" class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" dir="ltr" data-theme="theme-default" data-assets-path="assets/" data-template="vertical-menu-template" data-style="light">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>Fixtures | FPL Maestros</title>
    <?php include('nav.php') ?>
    <style>
        .fixture-card {
            transition: all 0.3s ease;
            border: 1px solid #e0e0e0;
            border-radius: 12px;
            overflow: hidden;
            margin-bottom: 1rem;
        }
        
        .fixture-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            border-color: #667eea;
        }
        
        .team-section {
            padding: 1rem;
            min-height: 120px;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }
        
        .home-team {
            background: #f8f9fa;
        }
        
        .away-team {
            background: #f8f9fa;
        }
        
        .vs-section {
            background: #f8f9fa;
            color: #6c757d;
            padding: 1rem;
            display: flex;
            align-items: center;
            justify-content: center;
            border-left: 1px solid #e9ecef;
            border-right: 1px solid #e9ecef;
        }
        
        .team-logo {
            width: 40px;
            height: 40px;
            object-fit: contain;
            margin-bottom: 0.5rem;
            border-radius: 8px;
            background: white;
            padding: 4px;
        }
        
        .team-name {
            font-weight: 600;
            color: #2d3748;
            text-align: center;
            line-height: 1.2;
            word-wrap: break-word;
            overflow-wrap: break-word;
            hyphens: auto;
        }
        
        /* Desktop */
        .team-name {
            font-size: 0.95em;
        }
        
        /* Tablet */
        @media (max-width: 768px) {
            .team-name {
                font-size: 0.9em;
            }
            .team-section {
                padding: 0.75rem;
                min-height: 110px;
            }
            .team-logo {
                width: 35px;
                height: 35px;
            }
        }
        
        /* Mobile */
        @media (max-width: 576px) {
            .team-name {
                font-size: 0.85em;
                line-height: 1.1;
            }
            .team-section {
                padding: 0.5rem;
                min-height: 100px;
            }
            .team-logo {
                width: 32px;
                height: 32px;
                margin-bottom: 0.25rem;
            }
            .vs-section {
                padding: 0.75rem;
            }
            .vs-text {
                font-size: 1em;
            }
        }
        
        /* Extra Small Mobile */
        @media (max-width: 400px) {
            .team-name {
                font-size: 0.8em;
            }
            .team-section {
                padding: 0.4rem;
                min-height: 90px;
            }
            .team-logo {
                width: 28px;
                height: 28px;
            }
        }
        
        .empty-state {
            text-align: center;
            padding: 3rem;
            color: #718096;
        }
        
        .empty-state i {
            font-size: 3rem;
            margin-bottom: 1rem;
            opacity: 0.5;
        }
        
        .card-title {
            color: #2d3748;
        }
        
        .header-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 1rem;
        }
        
        .gw-select-container {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        /* Mobile header adjustments */
        @media (max-width: 576px) {
            .header-container {
                flex-direction: column;
                align-items: stretch;
                gap: 0.75rem;
            }
            
            .gw-select-container {
                justify-content: space-between;
            }
            
            .card-header .header-container {
                flex-direction: row;
                align-items: center;
            }
        }
    </style>
</head>

<body>
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <form method="POST">
            <div class="container-xxl flex-grow-1 container-p-y">
                <div class="card">
                    <div class="card-header border-bottom">
                        <div class="header-container">
                            <div>
                                <h4 class="card-title mb-1">Fixtures</h4>
                                <!-- <p class="text-muted mb-0">View matches by gameweek</p> -->
                            </div>
                            <form method="POST" class="d-flex align-items-center gap-2">
                                <button class="btn btn-primary" name="generate_fixtures" 
                                        onclick="return confirm('Are you sure you want to generate fixtures? This will clear any existing fixtures')">
                                    Generate Fixtures
                                </button>
                                <input type="hidden" name="division" id="division" value="2">
                            </form>
                        </div>
                    </div>

                    <div class="card-body">
                        <!-- Gameweek Header -->
                        <div class="header-container mb-4">
                            <div>
                                <h4 id="gw-title" class="text-primary mb-0">Gameweek Fixtures</h4>
                            </div>
                            <div class="gw-select-container">
                                <span class="text-muted">Select Gameweek:</span>
                                <select class="form-select" id="gw-select" style="width: auto; min-width: 150px;">
                                    <option>Loading gameweeks...</option>
                                </select>
                            </div>
                        </div>

                        <!-- Fixtures Container -->
                        <div id="fixtures-container">
                            <div class="empty-state">
                                <i class="bx bx-calendar"></i>
                                <h4>No fixtures loaded</h4>
                                <p>Select a gameweek to view matches</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <?php 
                $sq = $db->query("SELECT * FROM results WHERE division = 2 ORDER BY gameweek DESC LIMIT 1");
                if (mysqli_num_rows($sq) < 1) {
                ?>
                    <input type="hidden" id="gw-no" value="1">
                <?php
                } else {
                    $fetch = mysqli_fetch_assoc($sq); ?>
                    <input type="hidden" id="gw-no" value="<?= $fetch['gameweek'] ?>">
                <?php } ?>
            </div>
        </form>
        <!-- / Content -->

        <script>
            $(document).ready(function() {
                loadGameweeks();
                
                $("#gw-select").change(function() {
                    let gw = $(this).val();
                    $("#gw-title").text("Gameweek " + gw + " Fixtures");
                    loadFixtures(gw);
                });
            });

            function loadGameweeks() {
                $.ajax({
                    method: "GET",
                    url: "connect.php",
                    data: {
                        get_gameweeks: 'Yes',
                        division: 2
                    }
                }).done(function(data) {
                    var gws = [];

                    if (Array.isArray(data)) {
                        gws = data;
                    } else if (data && Array.isArray(data.data)) {
                        gws = data.data;
                    } else if (typeof data === 'string' && data.trim().length) {
                        try {
                            var parsed = JSON.parse(data);
                            if (Array.isArray(parsed)) gws = parsed;
                        } catch (e) {
                            console.error('JSON parse failed', e);
                            showError('Failed to load gameweeks');
                            return;
                        }
                    } else {
                        console.error('Unexpected response format', data);
                        showError('Failed to load gameweeks');
                        return;
                    }

                    if (gws.length === 0) {
                        showError('No gameweeks available');
                        return;
                    }

                    var select = $('#gw-select').empty();
                    var initGw = $("#gw-no").val();
                    
                    gws.forEach(function(gw, idx) {
                        var opt = $('<option>').val(gw).text('Gameweek ' + gw);
                        if (gw == initGw) {
                            opt.prop('selected', true);
                            $("#gw-title").text("Gameweek " + initGw + " Fixtures");
                            loadFixtures(initGw);
                        }
                        select.append(opt);
                    });

                }).fail(function(xhr, status, err) {
                    console.error('AJAX error', status, err, xhr.responseText);
                    showError('Failed to load gameweeks');
                });
            }

            function loadFixtures(gw) {
                $.ajax({
                    method: "GET",
                    url: "connect.php",
                    data: {
                        get_fixtures: 'Yes',
                        gw: gw,
                        division: 2
                    }
                }).done(function(fixtures) {
                    renderFixtures(fixtures);
                }).fail(function(xhr, status, err) {
                    console.error('AJAX error', status, err, xhr.responseText);
                    showError('Failed to load fixtures');
                });
            }

            function renderFixtures(fixtures) {
                let container = $("#fixtures-container");
                container.empty();

                if (!fixtures || fixtures.length === 0) {
                    container.html(`
                        <div class="empty-state">
                            <i class="bx bx-football"></i>
                            <h4>No Fixtures</h4>
                            <p>No matches found for this gameweek</p>
                        </div>
                    `);
                    return;
                }

                fixtures.forEach(function(f, index) {
                    const fixtureCard = `
                    <div class="fixture-card">
                        <div class="row g-0">
                            <div class="col-5 team-section home-team">
                                <div class="d-flex flex-column align-items-center justify-content-center h-100">
                                    <img src="uploads/${f.home_logo}" 
                                         onerror="this.src='assets/img/avatars/1.png'" 
                                         alt="${f.home_team}" 
                                         class="team-logo">
                                    <div class="team-name">${f.home_team}</div>
                                </div>
                            </div>
                            
                            <div class="col-2 vs-section">
                                <div class="vs-text">VS</div>
                            </div>
                            
                            <div class="col-5 team-section away-team">
                                <div class="d-flex flex-column align-items-center justify-content-center h-100">
                                    <img src="uploads/${f.away_logo}" 
                                         onerror="this.src='assets/img/avatars/1.png'" 
                                         alt="${f.away_team}" 
                                         class="team-logo">
                                    <div class="team-name">${f.away_team}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    `;
                    container.append(fixtureCard);
                });
            }

            function showError(message) {
                $("#fixtures-container").html(`
                    <div class="empty-state">
                        <i class="bx bx-error"></i>
                        <h4>Error</h4>
                        <p>${message}</p>
                        <button class="btn btn-primary mt-2" onclick="loadGameweeks()">Try Again</button>
                    </div>
                `);
            }
        </script>

        <?php include('footer.php') ?>
    </div>
</body>
</html>