<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>League Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body class="bg-light">
    <div class="container-fluid p-4">

        <!-- Page Title -->
        <h2 class="mb-4">League Dashboard</h2>

        <!-- Top Cards -->
        <div class="row mb-4">
            <!-- Current GW -->
            <div class="col-md-4">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Current Gameweek</h5>
                        <p class="mb-1"><strong>GW:</strong> <span id="current-gw">--</span></p>
                        <p class="mb-1"><strong>Status:</strong> <span id="gw-status" class="badge bg-secondary">--</span></p>
                        <p><strong>Deadline:</strong> <span id="gw-deadline">--</span></p>
                        <a href="fixtures.php" class="btn btn-sm btn-outline-primary">View Fixtures</a>
                    </div>
                </div>
            </div>

            <!-- League Table Snapshot -->
            <div class="col-md-4">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Top Teams</h5>
                        <ul class="list-group list-group-flush small" id="table-snapshot">
                            <!-- Example -->
                            <li class="list-group-item d-flex justify-content-between">
                                <span>Team A</span><span>12 pts</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <span>Team B</span><span>10 pts</span>
                            </li>
                        </ul>
                        <a href="league_table.php" class="btn btn-sm btn-outline-primary mt-2">Full Table</a>
                    </div>
                </div>
            </div>

            <!-- Manager Highlight -->
            <div class="col-md-4">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Manager Highlight</h5>
                        <p class="mb-1"><strong>Top Manager:</strong> <span id="top-manager">--</span></p>
                        <p class="mb-1"><strong>Points:</strong> <span id="top-manager-points">--</span></p>
                        <p><strong>Lowest:</strong> <span id="low-manager">--</span></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Middle Row -->
        <div class="row mb-4">
            <!-- Recent Results -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Recent Results</h5>
                        <ul class="list-group list-group-flush" id="recent-results">
                            <!-- Example -->
                            <li class="list-group-item">Team A 2 - 1 Team B</li>
                            <li class="list-group-item">Team C 0 - 0 Team D</li>
                        </ul>
                    </div>
                </div>
            </div>

            <!-- Upcoming Fixtures -->
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">Upcoming Fixtures</h5>
                        <ul class="list-group list-group-flush" id="upcoming-fixtures">
                            <!-- Example -->
                            <li class="list-group-item">Team E vs Team F – Sat 15:00</li>
                            <li class="list-group-item">Team G vs Team H – Sun 17:30</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- Optional Stats -->
        <div class="row">
            <div class="col-md-12">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <h5 class="card-title">League Stats</h5>
                        <p>Total Goals: <span id="total-goals">--</span></p>
                        <p>Average Goals/Match: <span id="avg-goals">--</span></p>
                        <p>Most Consistent Team: <span id="consistent-team">--</span></p>
                    </div>
                </div>
            </div>
        </div>

    </div>
</body>

</html>