<?php
// populate_champions_cup.php
set_time_limit(600);
include('connect.php');



/**
 * Populate manager histories with realistic data up to GW10
 */
function populateManagerHistoriesUpToGW10() {
    global $db;
    
    // Get all managers from qualified teams
    $managers = [];
    $result = $db->query("SELECT manager1, manager2, manager3, manager4, manager5 
                         FROM teams");
    
    while ($row = $result->fetch_assoc()) {
        for ($i = 1; $i <= 5; $i++) {
            $manager_id = $row["manager$i"];
            if ($manager_id && !in_array($manager_id, $managers)) {
                $managers[] = $manager_id;
            }
        }
    }
    
    // Clear existing test data
    // $db->query("DELETE FROM manager_history WHERE event <= 38");
    
    // Populate manager history for GW1-10
    foreach ($managers as $manager_id) {
        $total_points = 0;
        
        for ($gw = 37; $gw <= 38; $gw++) {
            // Generate realistic FPL points per GW
            $points = rand(40, 100);
            $transfer_cost = rand(0, 12);
            $net_points = $points - $transfer_cost;
            $bench_points = rand(5, 25);
            $vice_captain_points = rand(2, 15);
            $team_goals = rand(0, 4);
            
            $db->query("INSERT INTO manager_history 
                       (manager_id, event, points, transfer_cost, net_points, bench_points, vice_captain_points, team_goals) 
                       VALUES ($manager_id, $gw, $points, $transfer_cost, $net_points, $bench_points, $vice_captain_points, $team_goals)");
            
            $total_points += $net_points;
        }
    }
    
    echo "Populated manager histories for " . count($managers) . " managers (GW1-10)<br>";
}

populateManagerHistoriesUpToGW10();