<!DOCTYPE html>

<html lang="en" class="light-style layout-navbar-fixed layout-menu-fixed layout-compact " dir="ltr" data-theme="theme-default" data-assets-path="assets/" data-template="vertical-menu-template" data-style="light">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>Champions Cup Groups | FPL Maestros</title>


    <?php include('nav.php') ?>



    <!-- Content wrapper -->
    <div class="content-wrapper">

        <!-- Content -->

        <div class="container-xxl flex-grow-1 container-p-y">


            <?php
            // championscup_groups.php
            function displayChampionsCupGroups($season = '2025')
            {
                global $db;

                echo "<div class='cup-groups'>";
                echo "<h4>🏆 Champions Cup - Group Stage</h4>";

                $groups = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H'];

                foreach ($groups as $group) {

                    echo "<div class='card mb-3'>";
                    echo "<div class='card-header border-bottom d-flex justify-content-between align-items-center>";
                    echo "<h6 class='card-title mb-0'>Group $group</h6>";
                    echo "<a href='#groupFixtures$group' class='p-0' data-bs-toggle='collapse' aria-expanded='false' aria-controls='groupFixtures$group'>
                        <i class='tf-icons ri-arrow-down-s-line'></i>
                    </a>";
                    echo "</div>";

                    // Group standings table
                    displayGroupStandings($group, $season);

                    // Group fixtures and results
                    displayGroupFixtures($group, $season);

                    echo "</div>";
                }

                // Qualification rules reminder
                echo "<div class='qualification-info'>";
                echo "<h3>📋 Qualification Rules</h3>";
                echo "<p>Top 2 teams from each group advance to Round of 16</p>";
                echo "<p>Tiebreakers: Points → Goal Difference → Goals For → Head-to-Head</p>";
                echo "</div>";

                echo "</div>";
            }
            displayChampionsCupGroups();
            // championscup_groups_functions.php

            /**
             * GROUP STAGE FUNCTIONS
             */

            function computeGroupStandingsByGroupNameDetailed($group_name, $season = '2025')
            {
                global $db;

                // Get the group ID
                $group_result = $db->query("SELECT id FROM cup_groups 
                               WHERE group_name = '" . $db->real_escape_string($group_name) . "' 
                               AND season_year = '" . $db->real_escape_string($season) . "'");

                if ($group_result->num_rows == 0) {
                    return [];
                }

                $group = $group_result->fetch_assoc();
                $group_id = $group['id'];

                // Get all teams in this group
                $teams_res = $db->query("SELECT cgt.team_id, t.team_name, t.logo, cgt.group_seed 
                            FROM cup_group_teams cgt 
                            JOIN teams t ON cgt.team_id = t.id 
                            WHERE cgt.group_id = $group_id 
                            ORDER BY cgt.group_seed");

                $standings = [];
                while ($team = $teams_res->fetch_assoc()) {
                    $standings[$team['team_id']] = [
                        'team_id' => $team['team_id'],
                        'team_name' => $team['team_name'],
                        'logo' => $team['logo'],
                        'group_seed' => $team['group_seed'],
                        'played' => 0,
                        'won' => 0,
                        'drawn' => 0,
                        'lost' => 0,
                        'gf' => 0,
                        'ga' => 0,
                        'gd' => 0,
                        'points' => 0,
                        'home_goals' => 0,
                        'away_goals' => 0,
                        'form' => [],
                        'head_to_head' => []
                    ];
                }

                // Get all fixtures for this group
                $teamIds = array_keys($standings);
                $teamIdsStr = implode(',', $teamIds);

                $fixtures = $db->query("SELECT * FROM cup_fixtures 
                           WHERE stage = 'Group' 
                           AND season_year = '" . $db->real_escape_string($season) . "' 
                           AND home_team_id IN ($teamIdsStr) 
                           AND away_team_id IN ($teamIdsStr) 
                           AND status = 'Closed' 
                           ORDER BY gameweek");

                // Process each fixture
                while ($fixture = $fixtures->fetch_assoc()) {
                    $home_team = $fixture['home_team_id'];
                    $away_team = $fixture['away_team_id'];
                    $home_goals = intval($fixture['home_goals']);
                    $away_goals = intval($fixture['away_goals']);

                    // Update basic stats
                    $standings[$home_team]['played']++;
                    $standings[$away_team]['played']++;

                    $standings[$home_team]['gf'] += $home_goals;
                    $standings[$home_team]['ga'] += $away_goals;
                    $standings[$home_team]['home_goals'] += $home_goals;

                    $standings[$away_team]['gf'] += $away_goals;
                    $standings[$away_team]['ga'] += $home_goals;
                    $standings[$away_team]['away_goals'] += $away_goals;

                    // Update points and win/draw/loss
                    if ($home_goals > $away_goals) {
                        $standings[$home_team]['won']++;
                        $standings[$home_team]['points'] += 3;
                        $standings[$away_team]['lost']++;

                        // Record form
                        $standings[$home_team]['form'][] = 'W';
                        $standings[$away_team]['form'][] = 'L';
                    } elseif ($away_goals > $home_goals) {
                        $standings[$away_team]['won']++;
                        $standings[$away_team]['points'] += 3;
                        $standings[$home_team]['lost']++;

                        $standings[$home_team]['form'][] = 'L';
                        $standings[$away_team]['form'][] = 'W';
                    } else {
                        $standings[$home_team]['drawn']++;
                        $standings[$away_team]['drawn']++;
                        $standings[$home_team]['points'] += 1;
                        $standings[$away_team]['points'] += 1;

                        $standings[$home_team]['form'][] = 'D';
                        $standings[$away_team]['form'][] = 'D';
                    }

                    // Record head-to-head result
                    $standings[$home_team]['head_to_head'][$away_team] = [
                        'home_goals' => $home_goals,
                        'away_goals' => $away_goals,
                        'points' => $home_goals > $away_goals ? 3 : ($home_goals == $away_goals ? 1 : 0)
                    ];

                    $standings[$away_team]['head_to_head'][$home_team] = [
                        'home_goals' => $away_goals, // From their perspective when they play at home
                        'away_goals' => $home_goals,
                        'points' => $away_goals > $home_goals ? 3 : ($away_goals == $home_goals ? 1 : 0)
                    ];
                }

                // Calculate goal difference
                foreach ($standings as &$team) {
                    $team['gd'] = $team['gf'] - $team['ga'];

                    // Keep only last 5 form results
                    $team['form'] = array_slice($team['form'], -5);
                    $team['form_string'] = implode(' ', $team['form']);
                }

                // Sort standings with proper tiebreakers
                uasort($standings, function ($a, $b) use ($standings) {
                    // 1. Points
                    if ($a['points'] !== $b['points']) {
                        return $b['points'] - $a['points'];
                    }

                    // 2. Goal Difference
                    if ($a['gd'] !== $b['gd']) {
                        return $b['gd'] - $a['gd'];
                    }

                    // 3. Goals For
                    if ($a['gf'] !== $b['gf']) {
                        return $b['gf'] - $a['gf'];
                    }

                    // 4. Head-to-Head record
                    $head_to_head = compareHeadToHead($a['team_id'], $b['team_id'], $standings);
                    if ($head_to_head !== 0) {
                        return $head_to_head;
                    }

                    // 5. Away Goals (in group matches)
                    if ($a['away_goals'] !== $b['away_goals']) {
                        return $b['away_goals'] - $a['away_goals'];
                    }

                    // 6. Original seed (lowest seed number wins)
                    return $a['group_seed'] - $b['group_seed'];
                });

                // Add positions
                $position = 1;
                foreach ($standings as &$team) {
                    $team['position'] = $position;
                    $position++;
                }

                return array_values($standings);
            }

            /**
             * Compare head-to-head record between two teams
             */
            function compareHeadToHead($team_a_id, $team_b_id, $standings)
            {
                if (
                    !isset($standings[$team_a_id]['head_to_head'][$team_b_id]) ||
                    !isset($standings[$team_b_id]['head_to_head'][$team_a_id])
                ) {
                    return 0; // No head-to-head matches played
                }

                $a_vs_b = $standings[$team_a_id]['head_to_head'][$team_b_id];
                $b_vs_a = $standings[$team_b_id]['head_to_head'][$team_a_id];

                // Compare points from head-to-head matches
                $a_points = $a_vs_b['points'] + $b_vs_a['points'];
                $b_points = $b_vs_a['points'] + $a_vs_b['points'];

                if ($a_points !== $b_points) {
                    return $b_points - $a_points;
                }

                // Compare goal difference in head-to-head matches
                $a_gd = ($a_vs_b['home_goals'] + $b_vs_a['away_goals']) - ($a_vs_b['away_goals'] + $b_vs_a['home_goals']);
                $b_gd = ($b_vs_a['home_goals'] + $a_vs_b['away_goals']) - ($b_vs_a['away_goals'] + $a_vs_b['home_goals']);

                if ($a_gd !== $b_gd) {
                    return $b_gd - $a_gd;
                }

                // Compare away goals in head-to-head matches
                $a_away_goals = $b_vs_a['away_goals'];
                $b_away_goals = $a_vs_b['away_goals'];

                if ($a_away_goals !== $b_away_goals) {
                    return $b_away_goals - $a_away_goals;
                }

                return 0;
            }


            function displayGroupStandings($group_name, $season = '2025')
            {
                global $db;

                $standings = computeGroupStandingsByGroupNameDetailed($group_name, $season);

                echo "<div class='card-body row d-flex justify-content-between align-items-center'>";
                echo "<div class='card-datatable table-responsive'>";
                echo "<table class='table table-striped'>";
                echo "<thead>";
                echo "<tr>";
                echo "<th>Pos</th>";
                echo "<th>Team</th>";
                echo "<th>P</th>";
                echo "<th>W</th>";
                echo "<th>D</th>";
                echo "<th>L</th>";
                echo "<th>GF</th>";
                echo "<th>GA</th>";
                echo "<th>GD</th>";
                echo "<th>Pts</th>";
                echo "<th>Form</th>";
                echo "</tr>";
                echo "</thead>";
                echo "<tbody>";

                foreach ($standings as $team) {
                    $qualification_class = $team['position'] <= 2 ? 'qualified' : '';
                    echo "<tr class='$qualification_class'>";
                    echo "<td>{$team['position']}</td>";
                    echo "<td><span class='team-logo'><img src='uploads/{$team['logo']}' onerror='this.src='assets/img/avatars/1.png'' alt='{$team['team_name']}' class='mx-3' style='height: 34px; width: 29px; object-fit: contain;'></span>{$team['team_name']}</td>";
                    echo "<td>{$team['played']}</td>";
                    echo "<td>{$team['won']}</td>";
                    echo "<td>{$team['drawn']}</td>";
                    echo "<td>{$team['lost']}</td>";
                    echo "<td>{$team['gf']}</td>";
                    echo "<td>{$team['ga']}</td>";
                    echo "<td>{$team['gd']}</td>";
                    echo "<td><strong>{$team['points']}</strong></td>";
                    echo "<td>{$team['form_string']}</td>";
                    echo "</tr>";
                }

                echo "</tbody>";
                echo "</table>";
                echo "</div>";
                echo "</div>";
            }

            function displayGroupFixtures($group_name, $season = '2025')
            {
                global $db;

                $group = $db->query("SELECT id FROM cup_groups WHERE group_name = '$group_name' AND season_year = '$season'")->fetch_assoc();
                if (!$group) return;

                $fixtures = $db->query("SELECT f.*, t1.team_name as home_team, t2.team_name as away_team 
                           FROM cup_fixtures f 
                           JOIN teams t1 ON f.home_team_id = t1.id 
                           JOIN teams t2 ON f.away_team_id = t2.id 
                           JOIN cup_group_teams cgt ON f.home_team_id = cgt.team_id 
                           WHERE cgt.group_id = {$group['id']} 
                           AND f.season_year = '$season' 
                           AND f.stage = 'Group' 
                           ORDER BY f.gameweek, f.id");
                echo "<div id='groupFixtures$group_name' class='collapse'>";
                echo "<div class='card-body'>";
                echo "<h4>Fixtures & Results</h4>";

                $current_gw = null;
                while ($fixture = $fixtures->fetch_assoc()) {
                    if ($current_gw != $fixture['gameweek']) {
                        if ($current_gw !== null) echo "</div>"; // Close previous matchday
                        echo "<div class='matchday mb-4'>";
                        echo "<h5 class='mb-3'>Matchday " . getMatchdayFromGW($fixture['gameweek']) . " (GW{$fixture['gameweek']})</h5>";
                        $current_gw = $fixture['gameweek'];
                    }

                    $status_class = $fixture['status'] == 'Closed' ? 'completed' : 'upcoming';

                    echo "<div class='fixture $status_class mb-2 p-2 border rounded'>";
                    echo "<div class='card-body d-flex align-items-center text-center'>";

                    // Home team
                    echo "<div class='flex-fill text-end pe-2'>{$fixture['home_team']}</div>";

                    // Score/VS
                    if ($fixture['status'] == 'Closed') {
                        echo "<div class='flex-shrink-0 px-3 fw-bold'>{$fixture['home_goals']} : {$fixture['away_goals']}</div>";
                    } else {
                        echo "<div class='flex-shrink-0 px-3 text-muted'>vs</div>";
                    }

                    // Away team
                    echo "<div class='flex-fill text-start ps-2'>{$fixture['away_team']}</div>";

                    echo "</div>"; // Close card-body
                    echo "</div>"; // Close fixture
                }

                if ($current_gw !== null) echo "</div>"; // Close last matchday
                echo "</div>"; // Close card-body
                echo "</div>"; // Close collapse
            }

            function getTeamForm($team_id, $season, $matches = 5)
            {
                global $db;

                $form = '';
                $results = $db->query("SELECT * FROM cup_fixtures 
                          WHERE (home_team_id = $team_id OR away_team_id = $team_id) 
                          AND season_year = '$season' 
                          AND status = 'Closed' 
                          ORDER BY gameweek DESC 
                          LIMIT $matches");

                while ($match = $results->fetch_assoc()) {
                    if ($match['home_team_id'] == $team_id) {
                        if ($match['home_goals'] > $match['away_goals']) {
                            $form .= 'W ';
                        } elseif ($match['home_goals'] < $match['away_goals']) {
                            $form .= 'L ';
                        } else {
                            $form .= 'D ';
                        }
                    } else {
                        if ($match['away_goals'] > $match['home_goals']) {
                            $form .= 'W ';
                        } elseif ($match['away_goals'] < $match['home_goals']) {
                            $form .= 'L ';
                        } else {
                            $form .= 'D ';
                        }
                    }
                }

                return trim($form);
            }

            function getMatchdayFromGW($gameweek)
            {
                $matchdays = [
                    12 => 1,
                    14 => 2,
                    16 => 3,
                    18 => 4,
                    20 => 5,
                    22 => 6
                ];
                return $matchdays[$gameweek] ?? 0;
            }
            ?>



        </div>
        <!-- / Content -->


        <?php include('footer.php') ?>


        </body>

</html>