<!DOCTYPE html>

<html lang="en" class="light-style layout-navbar-fixed layout-menu-fixed layout-compact " dir="ltr" data-theme="theme-default" data-assets-path="../../assets/" data-template="vertical-menu-template" data-style="light">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>Champions Cup Groups | FPL Maestros</title>


    <?php include('../nav.php') ?>



    <!-- Content wrapper -->
    <div class="content-wrapper">

        <!-- Content -->

        <div class="container-xxl flex-grow-1 container-p-y">



            <!-- Users List Table -->
            <div class="card">
                <div class="card-header border-bottom">
                    <h6 class="card-title mb-0">Division 1</h6>
                </div>
                <div class="card-datatable table-responsive">
                    <table class="table table-striped" id="leagueTable">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Team</th>
                                <th>P</th>
                                <th>W</th>
                                <th>D</th>
                                <th>L</th>
                                <th>GF</th>
                                <th>GA</th>
                                <th>GD</th>
                                <th>Pts</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>



           
            </div>


        </div>
        <!-- / Content -->


        <?php include('footer.php') ?>

        <script>
            function refreshLeagueTable() {
                $.ajax({
                    url: "connect.php",
                    method: "GET",
                    data: {
                        refreshLeagueTable: "Yes",
                         division: 1
                    },
                    success: function(data) {
                        let html = "";
                        let pos = 1;
                        data.forEach(row => {
                            html += `
                    <tr>
                        <td>${pos++}</td>
                        <td><span class="team-logo"><img src="uploads/${row.logo}" onerror="this.src='../../assets/img/avatars/1.png'" alt="${row.team_name}" class="mx-3" style="height: 34px; width: 29px; object-fit: contain;"></span>${row.team_name}</td>
                        <td>${row.played}</td>
                        <td>${row.won}</td>
                        <td>${row.drawn}</td>
                        <td>${row.lost}</td>
                        <td>${row.goals_for}</td>
                        <td>${row.goals_against}</td>
                        <td>${row.goal_difference}</td>
                        <td>${row.points}</td>
                    </tr>`;
                        });
                        $("#leagueTable tbody").html(html);
                        

                    }
                });
            }

            // Refresh on page load
          $(document).ready(function(){
              refreshLeagueTable();
          });

            
        // $('#leagueTable').DataTable({
        //   pageLength: 10,
        //   lengthChange: true,
        //   ordering: true,
        //   searching: true
        // });
            // Auto-refresh every 30 seconds
            // setInterval(refreshLeagueTable, 30000);

            
        </script>
        </body>

</html>