<!DOCTYPE html>
<html lang="zxx">

<head>
    <!-- Meta -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1">
    <meta name="description" content="FPL Maestros - Page Not Found">
    <meta name="keywords" content="FPL, Fantasy Premier League, Football, Soccer, Premier League">
    <meta name="author" content="FPL Maestros">
    <!-- Page Title -->
    <title>Page Not Found - FPL Maestros</title>
    
    <!-- FPL Color Theme -->
    <style>
        :root {
            --primary-color: #37003c;
            --secondary-color: #FFFFFF1A;
            --text-color: #999999;
            --accent-color: #00ff85;
            --white-color: #FFFFFF;
            --divider-color: #0315211A;
            --dark-divider-color: #FFFFFF1A;
            --error-color: rgb(230, 87, 87);
            --default-font: "Manrope", sans-serif;
            --accent-font: "Bebas Neue", sans-serif;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: var(--default-font);
            background: linear-gradient(135deg, var(--primary-color) 0%, #1f0022 100%);
            color: var(--white-color);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }

        .dark-section {
            background: linear-gradient(135deg, var(--primary-color) 0%, #1f0022 100%) !important;
        }

        .page-header {
            background: var(--primary-color);
            padding: 4rem 0 2rem;
        }

        .page-header-box p.lead {
            color: #e2e8f0 !important;
            font-size: 1.25rem;
        }

        /* 404 Content Styles */
        .error-container {
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 4rem 1rem;
        }

        .error-content {
            text-align: center;
            max-width: 700px;
            margin: 0 auto;
        }

        .error-number {
            font-size: 8rem;
            font-weight: 800;
            line-height: 1;
            color: var(--accent-color);
            margin-bottom: 1rem;
            text-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
        }

        .error-title {
            font-size: 2.5rem;
            margin-bottom: 1.5rem;
            color: var(--white-color);
        }

        .error-description {
            font-size: 1.2rem;
            color: var(--text-color);
            margin-bottom: 2.5rem;
            line-height: 1.6;
        }

        .error-actions {
            display: flex;
            gap: 1rem;
            justify-content: center;
            flex-wrap: wrap;
            margin-bottom: 3rem;
        }

        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            font-weight: 600;
            text-decoration: none;
            transition: all 0.3s ease;
            border: none;
            cursor: pointer;
            font-size: 1rem;
        }

        .btn-primary {
            background: var(--accent-color);
            color: var(--primary-color);
        }

        .btn-primary:hover {
            background: #00e676;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 255, 133, 0.3);
        }

        .btn-secondary {
            background: rgba(255, 255, 255, 0.1);
            color: var(--white-color);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .btn-secondary:hover {
            background: rgba(255, 255, 255, 0.2);
            transform: translateY(-2px);
        }

        .error-search {
            max-width: 500px;
            margin: 0 auto 2rem;
        }

        .search-form {
            display: flex;
            gap: 0.5rem;
        }

        .search-input {
            flex: 1;
            padding: 0.75rem 1rem;
            border-radius: 8px;
            border: 1px solid rgba(255, 255, 255, 0.2);
            background: rgba(255, 255, 255, 0.1);
            color: var(--white-color);
            font-size: 1rem;
        }

        .search-input::placeholder {
            color: rgba(255, 255, 255, 0.5);
        }

        .search-input:focus {
            outline: none;
            border-color: var(--accent-color);
            box-shadow: 0 0 0 2px rgba(0, 255, 133, 0.2);
        }

        .btn-search {
            background: var(--accent-color);
            color: var(--primary-color);
            border: none;
            border-radius: 8px;
            padding: 0 1.5rem;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .btn-search:hover {
            background: #00e676;
        }

        .error-stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
            gap: 1rem;
            margin-top: 3rem;
        }

        .stat-card {
            background: rgba(255, 255, 255, 0.05);
            border-radius: 12px;
            padding: 1.5rem;
            text-align: center;
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .stat-number {
            font-size: 2rem;
            font-weight: bold;
            color: var(--accent-color);
            display: block;
            line-height: 1;
        }

        .stat-label {
            font-size: 0.9em;
            color: var(--text-color);
            margin-top: 0.5rem;
        }

        /* Football Animation */
        .football-animation {
            position: relative;
            height: 150px;
            margin: 2rem auto;
        }

        .football {
            width: 60px;
            height: 60px;
            background: white;
            border-radius: 50%;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background-image: radial-gradient(circle at 30% 30%, #f0f0f0, #c0c0c0);
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.3);
            animation: bounce 2s infinite alternate;
        }

        .football::before {
            content: "";
            position: absolute;
            width: 100%;
            height: 100%;
            background: 
                radial-gradient(circle at 30% 30%, transparent 10%, #333 10%, #333 15%, transparent 15%),
                radial-gradient(circle at 70% 70%, transparent 10%, #333 10%, #333 15%, transparent 15%),
                linear-gradient(45deg, transparent 45%, #333 45%, #333 55%, transparent 55%),
                linear-gradient(-45deg, transparent 45%, #333 45%, #333 55%, transparent 55%);
            border-radius: 50%;
        }

        @keyframes bounce {
            0% {
                transform: translate(-50%, -50%) scale(1);
            }
            100% {
                transform: translate(-50%, -70%) scale(1.05);
            }
        }

        /* Navigation Styles */
        .navbar {
            background: rgba(55, 0, 60, 0.95);
            backdrop-filter: blur(10px);
            padding: 1rem 0;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .navbar-brand {
            color: var(--white-color);
            font-weight: bold;
            font-size: 1.5rem;
            text-decoration: none;
        }

        .navbar-nav {
            display: flex;
            list-style: none;
            gap: 1.5rem;
        }

        .nav-link {
            color: var(--white-color);
            text-decoration: none;
            transition: color 0.3s ease;
        }

        .nav-link:hover {
            color: var(--accent-color);
        }

        /* Footer Styles */
        .footer {
            background: rgba(0, 0, 0, 0.2);
            padding: 2rem 0;
            margin-top: auto;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
        }

        .footer-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 1rem;
        }

        .footer-links {
            display: flex;
            gap: 1.5rem;
        }

        .footer-link {
            color: var(--text-color);
            text-decoration: none;
            transition: color 0.3s ease;
        }

        .footer-link:hover {
            color: var(--accent-color);
        }

        /* Responsive Styles */
        @media (max-width: 768px) {
            .error-number {
                font-size: 6rem;
            }
            
            .error-title {
                font-size: 2rem;
            }
            
            .error-description {
                font-size: 1rem;
            }
            
            .error-actions {
                flex-direction: column;
                align-items: center;
            }
            
            .btn {
                width: 100%;
                max-width: 250px;
            }
            
            .search-form {
                flex-direction: column;
            }
            
            .error-stats {
                grid-template-columns: repeat(2, 1fr);
            }
            
            .navbar-nav {
                flex-direction: column;
                gap: 0.5rem;
            }
            
            .footer-content {
                flex-direction: column;
                text-align: center;
            }
        }

        @media (max-width: 480px) {
            .error-number {
                font-size: 4rem;
            }
            
            .error-title {
                font-size: 1.5rem;
            }
            
            .error-stats {
                grid-template-columns: 1fr;
            }
        }
    </style>

    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>

<body>
    <!-- Navigation -->
    <!-- <nav class="navbar">
        <div class="container">
            <div class="navbar-content">
                <a href="index.php" class="navbar-brand">
                    <i class="fas fa-futbol me-2"></i>FPL Maestros
                </a>
                <ul class="navbar-nav">
                    <li><a href="index.php" class="nav-link">Home</a></li>
                    <li><a href="fixtures.php" class="nav-link">Fixtures</a></li>
                    <li><a href="standings.php" class="nav-link">Standings</a></li>
                    <li><a href="players.php" class="nav-link">Players</a></li>
                    <li><a href="about.php" class="nav-link">About</a></li>
                </ul>
            </div>
        </div>
    </nav> -->

    <!-- 404 Content -->
    <div class="error-container">
        <div class="container">
            <div class="error-content">
                
                
                <div class="error-number">404</div>
                
                <h1 class="error-title">Oops! Page Not Found</h1>
                
                <p class="error-description">
                    It looks like this page has been substituted off the pitch. 
                    The link might be broken, the page may have been removed, or you entered an invalid URL.
                </p>
                
               
                
                
                <div class="error-stats">
                    <div class="stat-card">
                        <span class="stat-number">20</span>
                        <span class="stat-label">Teams</span>
                    </div>
                    <div class="stat-card">
                        <span class="stat-number">380</span>
                        <span class="stat-label">Matches</span>
                    </div>
                    <div class="stat-card">
                        <span class="stat-number">500+</span>
                        <span class="stat-label">Players</span>
                    </div>
                    
                </div>
            </div>
        </div>
    </div>

    <!-- Footer -->
   

    <script>
        // Simple search functionality
        document.querySelector('.search-form').addEventListener('submit', function(e) {
            e.preventDefault();
            const searchTerm = document.querySelector('.search-input').value.trim();
            if (searchTerm) {
                // In a real implementation, this would redirect to search results
                alert(`Searching for: ${searchTerm}\n\nThis would redirect to search results in a complete implementation.`);
            }
        });

        // Add some interactivity to the football
        const football = document.querySelector('.football');
        football.addEventListener('click', function() {
            this.style.animation = 'none';
            setTimeout(() => {
                this.style.animation = 'bounce 2s infinite alternate';
            }, 10);
        });
    </script>
</body>

</html>